--***********************************************************
--**                    ShadowCop		                   **
--***********************************************************

require "TimedActions/ISBaseTimedAction"

ISStopChainsawAction = ISBaseTimedAction:derive("ISStopChainsawAction");

function ISStopChainsawAction:isValid()
	self.ModData = self.chainsaw:getModData();
	return self.chainsaw ~= nil and self.character:isEquipped(chainsaw);
end

function ISStopChainsawAction:update()
	self.chainsaw:setJobDelta(self:getJobDelta());
end

function ISStopChainsawAction:start()
	self.chainsaw:setJobType(getText("ContextMenu_StopChainsaw"));
	self.chainsaw:setJobDelta(0.0);
end

function ISStopChainsawAction:stop()
	ISBaseTimedAction.stop(self);
    self.chainsaw:setJobDelta(0.0);
end

function ISStopChainsawAction:perform()
	-- Values for Chainsaw OFF
	self.ModData.Run = false;
	self.chainsaw:setJobDelta(0.0);
		
    -- needed to remove from queue / start next
	ISBaseTimedAction.perform(self);
end

function ISStopChainsawAction:new(character, chainsaw, time)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o.character = character;
	o.stopOnWalk = false;
	o.stopOnRun = true;
	o.maxTime = time;
	-- custom fields
	o.chainsaw = chainsaw;	
	return o;
end